<?php
session_start();
include 'config.php';

// Cek Login
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
$user_id = $_SESSION['user_id'];
$active_menu = 'home'; // Tetap highlight home karena ini sub-menu

// Data Paket (Simulasi Database)
$paket_standar = [
    ['price' => 25000000, 'name' => 'Standar 25'],
    ['price' => 50000000, 'name' => 'Standar 50'],
    ['price' => 100000000, 'name' => 'Standar 100']
];
$paket_premium = [
    ['price' => 25000000, 'name' => 'Premium 25'],
    ['price' => 50000000, 'name' => 'Premium 50'],
    ['price' => 100000000, 'name' => 'Premium 100']
];
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Program Stokis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { darkMode: 'class', theme: { extend: { colors: { primary: '#10b981', darkbg: '#0f172a' } } } }</script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 dark:bg-darkbg text-gray-800 dark:text-gray-200 transition-colors duration-300">

    <div class="max-w-md mx-auto min-h-screen relative shadow-2xl bg-white dark:bg-slate-900 pb-24">
        
        <div class="bg-blue-600 p-6 pt-8 rounded-b-[2.5rem] shadow-lg text-white relative">
            <div class="flex items-center">
                <a href="dashboard.php" class="bg-white/20 p-2 rounded-full hover:bg-white/30 transition"><i class="fas fa-arrow-left"></i></a>
                <h1 class="ml-4 font-bold text-xl">Program Stokis</h1>
            </div>
            <p class="mt-4 text-blue-100 text-sm text-center">Jadilah bagian dari distribusi produk kami dan dapatkan Cashback bulanan.</p>
        </div>

        <div class="px-6 mt-6">
            <div class="flex bg-gray-100 dark:bg-slate-800 p-1 rounded-xl">
                <button onclick="switchTab('standar')" id="tab-standar" class="flex-1 py-2 rounded-lg text-sm font-bold bg-white dark:bg-slate-700 shadow-sm text-blue-600 transition">Standar</button>
                <button onclick="switchTab('premium')" id="tab-premium" class="flex-1 py-2 rounded-lg text-sm font-bold text-gray-500 hover:text-blue-500 transition">Premium</button>
            </div>
        </div>

        <div id="content-standar" class="px-6 mt-6 space-y-4 animate-[fadeIn_0.5s]">
            <div class="bg-blue-50 dark:bg-slate-800/50 p-3 rounded-lg border border-blue-200 dark:border-blue-900 text-xs text-blue-800 dark:text-blue-300 mb-4">
                <i class="fas fa-info-circle mr-1"></i> Cashback 10% / Bulan (Kontrak 3-6 Bulan)
            </div>
            
            <?php foreach($paket_standar as $pkg): ?>
            <div class="bg-white dark:bg-slate-800 rounded-2xl p-5 shadow-sm border border-gray-100 dark:border-slate-700 relative overflow-hidden group">
                <div class="absolute right-0 top-0 bg-blue-500 text-white text-[10px] font-bold px-3 py-1 rounded-bl-xl">STANDAR</div>
                <h3 class="font-bold text-lg mb-1 text-gray-700 dark:text-gray-200"><?php echo $pkg['name']; ?></h3>
                <h2 class="text-2xl font-bold text-blue-600 mb-3">Rp <?php echo number_format($pkg['price']); ?></h2>
                <ul class="text-xs text-gray-500 dark:text-gray-400 space-y-1 mb-4">
                    <li><i class="fas fa-check text-green-500 mr-1"></i> Cashback 10% (Rp <?php echo number_format($pkg['price']*0.1); ?>)/bln</li>
                    <li><i class="fas fa-clock text-blue-500 mr-1"></i> Pilihan Tenor: 3 atau 6 Bulan</li>
                </ul>
                <button onclick="openBuyModal('<?php echo $pkg['name']; ?>', <?php echo $pkg['price']; ?>, 'standar')" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-xl shadow-lg transition active:scale-95">
                    Ambil Paket
                </button>
            </div>
            <?php endforeach; ?>
        </div>

        <div id="content-premium" class="px-6 mt-6 space-y-4 hidden animate-[fadeIn_0.5s]">
            <div class="bg-yellow-50 dark:bg-slate-800/50 p-3 rounded-lg border border-yellow-200 dark:border-yellow-900 text-xs text-yellow-800 dark:text-yellow-300 mb-4">
                <i class="fas fa-crown mr-1"></i> Prioritas Stok & Cashback 10% (3-12 Bulan)
            </div>

            <?php foreach($paket_premium as $pkg): ?>
            <div class="bg-gradient-to-br from-slate-800 to-slate-900 rounded-2xl p-5 shadow-lg border border-yellow-500/30 relative overflow-hidden text-white">
                <div class="absolute right-0 top-0 bg-yellow-500 text-black text-[10px] font-bold px-3 py-1 rounded-bl-xl">PREMIUM</div>
                <h3 class="font-bold text-lg mb-1 text-yellow-400"><?php echo $pkg['name']; ?></h3>
                <h2 class="text-2xl font-bold text-white mb-3">Rp <?php echo number_format($pkg['price']); ?></h2>
                <ul class="text-xs text-gray-300 space-y-1 mb-4">
                    <li><i class="fas fa-check text-yellow-400 mr-1"></i> Cashback 10% (Rp <?php echo number_format($pkg['price']*0.1); ?>)/bln</li>
                    <li><i class="fas fa-clock text-yellow-400 mr-1"></i> Pilihan Tenor: 3, 6, 12 Bulan</li>
                </ul>
                <button onclick="openBuyModal('<?php echo $pkg['name']; ?>', <?php echo $pkg['price']; ?>, 'premium')" class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-bold py-3 rounded-xl shadow-lg transition active:scale-95">
                    Ambil Paket
                </button>
            </div>
            <?php endforeach; ?>
        </div>

        <div id="buyModal" class="fixed inset-0 bg-black/80 hidden z-[60] flex items-end sm:items-center justify-center px-4 backdrop-blur-sm">
            <div class="bg-white dark:bg-slate-800 w-full max-w-sm rounded-t-3xl sm:rounded-3xl p-6 relative animate-[slideUp_0.3s_ease-out]">
                <button onclick="closeModal()" class="absolute top-4 right-4 text-gray-400 hover:text-red-500"><i class="fas fa-times text-xl"></i></button>
                
                <h3 class="font-bold text-xl mb-1">Konfirmasi Pembelian</h3>
                <p id="modalPkgName" class="text-blue-600 font-bold mb-4">Nama Paket</p>
                
                <form action="process.php" method="POST" enctype="multipart/form-data" class="space-y-4">
                    <input type="hidden" name="action" value="buy_stokis">
                    <input type="hidden" name="package_name" id="inputPkgName">
                    <input type="hidden" name="amount" id="inputAmount">
                    <input type="hidden" name="category" id="inputCategory">

                    <div>
                        <label class="block text-xs font-bold text-gray-500 mb-1">Durasi Kontrak</label>
                        <select name="duration" id="durationSelect" class="w-full bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700 rounded-xl p-3 text-sm font-bold">
                            <option value="3">3 Bulan</option>
                            <option value="6">6 Bulan</option>
                            <option value="12" id="opt12">12 Bulan</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-500 mb-1">Metode Pembayaran</label>
                        <select name="payment_method" class="w-full bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700 rounded-xl p-3 text-sm font-bold">
                            <option value="Transfer Bank BCA">Transfer Bank BCA</option>
                            <option value="USDT">Crypto USDT (TRC20)</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-500 mb-1">Bukti Transfer</label>
                        <input type="file" name="proof" required class="w-full text-xs bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700 rounded-xl p-2">
                    </div>

                    <div class="bg-blue-50 dark:bg-slate-700/50 p-3 rounded-lg text-xs text-center">
                        Total Tagihan: <br>
                        <span id="modalPrice" class="text-lg font-bold text-blue-600">Rp 0</span>
                    </div>

                    <button type="submit" class="w-full bg-primary hover:bg-emerald-600 text-white font-bold py-3 rounded-xl shadow-lg mt-2">
                        Bayar Sekarang
                    </button>
                </form>
            </div>
        </div>

        <?php include 'footer_nav.php'; ?>
    </div>

    <script>
        function switchTab(tab) {
            document.getElementById('content-standar').classList.add('hidden');
            document.getElementById('content-premium').classList.add('hidden');
            document.getElementById('tab-standar').className = "flex-1 py-2 rounded-lg text-sm font-bold text-gray-500 hover:text-blue-500 transition";
            document.getElementById('tab-premium').className = "flex-1 py-2 rounded-lg text-sm font-bold text-gray-500 hover:text-blue-500 transition";
            
            document.getElementById('content-' + tab).classList.remove('hidden');
            document.getElementById('tab-' + tab).className = "flex-1 py-2 rounded-lg text-sm font-bold bg-white dark:bg-slate-700 shadow-sm text-blue-600 transition";
        }

        function openBuyModal(name, price, category) {
            document.getElementById('modalPkgName').innerText = name;
            document.getElementById('inputPkgName').value = name;
            document.getElementById('inputAmount').value = price;
            document.getElementById('inputCategory').value = category;
            document.getElementById('modalPrice').innerText = 'Rp ' + price.toLocaleString();
            
            // Logic 12 Bulan hanya untuk Premium
            const opt12 = document.getElementById('opt12');
            if(category === 'standar') {
                opt12.style.display = 'none';
                document.getElementById('durationSelect').value = '3';
            } else {
                opt12.style.display = 'block';
            }
            
            document.getElementById('buyModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('buyModal').classList.add('hidden');
        }
    </script>
</body>
</html>